namespace Igra_sa_kartama
{
    public class Karta
    {
        private int cardValue;
        private int count;


        public int CardValue { get => cardValue; set => cardValue = value; }
        public int Count { get => count; set => count = value; }
        public int TotalValue { get => cardValue * count; }

        public Karta(int cardValue, int count = 1)
        {
            CardValue = cardValue;
            Count = count;
        }
    }


    internal class Program
    {
        public static List<Karta> NajveceVrednosti(int n, Karta[] karte)
        {
            List<Karta> najveceVrednosti = new List<Karta>();

            foreach (Karta karta in karte)
            {
                if (karta.TotalValue > 0) najveceVrednosti.Add(karta);
            }

            najveceVrednosti = najveceVrednosti.OrderByDescending(k => k.TotalValue).ToList();

            return najveceVrednosti;
        }

        public static bool SadrziKartu(Karta karta, int[] a, int x)
        {
            int n = a.Length;
            for (int i = x; i < n; i++)
            {
                if(a[i] == karta.CardValue) return true;
            }
            return false;
        }

        static void Main(string[] args)
        {
            int[] inut = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
            int n = inut[0]; // broj karata
            int q = inut[1]; // broj upita

            int[] a = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse); // karte

            for (int i = 0; i < q; i++)
            {
                Karta[] karteURuci = new Karta[n];

                for (int j = 0; j < n; j++) karteURuci[j] = new Karta(j + 1, 0); // inicijalizacija karata u ruci

                int[] upit = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse); // upit

                if (upit[0] == 1)
                {
                    int x = upit[1];

                    // uzimanje prvih x karata iz spila
                    for (int j = 0; j < x; j++)
                    {
                        int vrednostKarte = a[j];

                        karteURuci[vrednostKarte - 1].Count++;
                    }

                    // dobijanje karata sa najvecim vrednostima
                    List<Karta> najveceVrednosti = NajveceVrednosti(n, karteURuci);

                    // uklanjanje karata koje se ne nalaze u preostalom delu spila
                    for (int j = x; j < n; j++)
                    {
                        int vrednostKarte = a[j];

                        karteURuci[vrednostKarte - 1].Count++;

                        // dobijanje karata sa najvecim vrednostima
                        najveceVrednosti = NajveceVrednosti(n, karteURuci);

                        bool izbaceno = false;

                        foreach (Karta karta in najveceVrednosti)
                        {
                            if (!SadrziKartu(karta, a, j + 1))
                            {
                                karteURuci[karta.CardValue - 1].Count = 0;
                                izbaceno = true;
                                break;
                            }

                        }

                        // ako nije izbacena nijedna karta, izbacujemo onu sa najmanjom vrednošcu
                        if (!izbaceno)
                        {
                            karteURuci[najveceVrednosti[najveceVrednosti.Count - 1].CardValue - 1].Count = 0;
                        }
                    }

                    int zbirkarata = 0;
                    foreach (Karta karta in najveceVrednosti)
                    {
                        zbirkarata += karta.TotalValue;
                    }

                    Console.WriteLine(zbirkarata);
                }
                else
                {
                    int x = upit[1];
                    int y = upit[2];

                    a[x - 1] = y;
                }
            }
        }
    }
}